chrome.runtime.onMessage.addListener(function (message, sender, sendResponse) {
  const params = {
    ajax_mode: "search_customer2",
    customer_info: message.customerInfo,
    mode: "customer_input"
  };
  const query = new URLSearchParams(params);
  fetch(`https://manage-bunchino.reserve.ne.jp/manage/ajax.php?${query}`, {
    "headers": {
      "accept": "application/json, text/javascript, */*; q=0.01",
      "accept-language": "ja-JP,ja;q=0.9",
      "x-requested-with": "XMLHttpRequest",
      "Referer": "https://manage-bunchino.reserve.ne.jp/manage/grid_customer.php",
    },
    "body": null,
    "method": "GET",
  }).then(response => response.json()).then(data => {
    chrome.tabs.sendMessage(sender.tab.id, {
      event: "lookup_customer_response",
      message: data
    });
  }).catch(error => {
    console.error(error);
  });
  return true;
});
